package com.js.common.config;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author yjzhao
 * @Description 响应数据序列化配置--fastJson
 * @Date 2019/5/17 15:19
 * @Param 
 * @return 
 **/
@Configuration
public class FastJsonHttpMessageConfig {
    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        //1、定义一个convert转换消息的对象
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        // 2.添加fastJson的配置信息,比如，是否需要格式化返回的json数据
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        //默认如果为空值不进行序列化，如果需要序列化，在对应字段上进行标注@JSONField(serialzeFeatures = SerializerFeature.XXXXX)
        // 空值特别处理
        // WriteNullListAsEmpty 将Collection类型字段的字段空值输出为[]
        // WriteNullStringAsEmpty 将字符串类型字段的空值输出为空字符串 ""
        // WriteNullNumberAsZero 将数值类型字段的空值输出为0
        // WriteNullBooleanAsFalse 将Boolean类型字段的空值输出为false

        //设置格式化的时间格式
        fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
        fastJsonConfig.setSerializerFeatures(SerializerFeature.PrettyFormat,
                //输出值为null的字段
                SerializerFeature.WriteMapNullValue
                ////将Collection类型字段的字段空值输出为[]
                //SerializerFeature.WriteNullListAsEmpty,
                ////将字符串类型字段的空值输出为空字符串 ""
                //SerializerFeature.WriteNullStringAsEmpty,
                ////将数值类型字段的空值输出为0
                //SerializerFeature.WriteNullNumberAsZero,
                ////将Boolean类型字段的空值输出为false
                //SerializerFeature.WriteNullBooleanAsFalse,
                ////Date的日期轉換器
                //SerializerFeature.WriteDateUseDateFormat,
                ////打开循环引用, 使用${} 代替, 防止出现相互引用导致StackOverflowError
                //SerializerFeature.DisableCircularReferenceDetect
        );
        //fastJsonConfig.setCharset(Charset.forName("UTF-8"));

        //fastJsonConfig.setSerializeFilters((ValueFilter) (o, s, source) -> {
        //    //此处是关键,如果返回对象的变量为null,则自动变成""
        //    if (source == null) {
        //        return "";
        //    }
        //    return source;
        //});

        //2-1 处理中文乱码问题
        List<MediaType> fastMediaTypes = new ArrayList<>();
        fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastMediaTypes.add(MediaType.TEXT_PLAIN);
        fastMediaTypes.add(MediaType.MULTIPART_FORM_DATA);
        //添加对text/html的支持
        fastMediaTypes.add(MediaType.parseMediaType(MediaType.TEXT_HTML_VALUE + ";charset=UTF-8"));
        fastConverter.setSupportedMediaTypes(fastMediaTypes);
        // 3.在convert中添加配置信息
        fastConverter.setFastJsonConfig(fastJsonConfig);
        //HttpMessageConverter<?> converter = fastConverter;
        //return new HttpMessageConverters(converter);
        return new HttpMessageConverters(fastConverter);
    }
}
