package com.js.common.annotation;

import com.js.common.jsConstraint.PhoneValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * @Author yjzhao
 * @Description 手机验证码校验
 * @Date 2019/5/19 14:02
 * @Param 
 * @return 
 **/
@Target({ElementType.FIELD, ElementType.PARAMETER })
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = PhoneValidator.class)
public @interface Phone {
    boolean required() default true;
    // 这个地方修改错误提示字符，其他地方不要修改
    String message() default "手机号码错误";

    Class<?>[] groups() default { };

    Class<? extends Payload>[] payload() default { };
}
