package com.js.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

import java.util.HashMap;
import java.util.Map;

public class ExchangeUtils {
    public static void main(String args[]){
        JSONArray waihui =ExchangeUtils.getValue("");
        System.out.println(waihui.toString());
    }

    private final static String idcardcerthost = "https://ali-waihui.showapi.com";
    private final static String path = "/waihui-list";
    private final static String method = "GET";
    private final static String appcode = "a158bfeb333543ac9a0bb964349266c9";

    /**
     * USD美金，EUR欧元，GBP英镑，JPY日元
     *
     名称	字段描述
     listSize	返回的数据列表长度
     list	数据列表
     - name	货币名称
     - code	货币简码
     - hui_in	现汇买入价
     - chao_in	现钞买入价
     - hui_out	现汇卖出价
     - chao_out	现钞卖出价
     - zhesuan	中行折算价
     - day	发布天
     - time	发布时间
     * @param currencyCode
     * @return
     */
    public static JSONArray getValue(String currencyCode){
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        Map<String, String> querys = new HashMap<String, String>();
        if(StringUtils.isNoneBlank(currencyCode)){
            querys.put("code", currencyCode);
        }else {
            querys.put("code", "");
        }
        JSONArray waihui = null;
        try {
            HttpResponse response = AliyunHttpUtils.doGet(idcardcerthost, path, method, headers, querys);
//            System.out.println(response.toString());
            JSONObject jsonObject = JSON.parseObject(EntityUtils.toString(response.getEntity()));
            if(jsonObject.getIntValue("ret_code") == 0 ){
                waihui = (JSONArray)jsonObject.getJSONObject("showapi_res_body").getJSONArray("list");
//                waihui = waihuiArray.getJSONObject(0);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return  waihui;
    }

}
