package com.js.common.model.vo;

import com.js.common.enums.StatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @ClassName: JsPayVatPaymentInfoVO
 * @Description: JsPayVatPaymentInfoVO VAT缴税
 * @Author: liwm
 * @Create: 2019-06-26
 **/
@Data
public class JsPayVatPaymentInfoVO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 缴税人姓名
     */
    private String kycNaturalName;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 店铺编号
     */
    private String subAcctNo;

    /**
     * 组织机构代码
     */
    private String orgCode;

    /**
     * 税局机构id
     */
    private String taxStationId;

    /**
     * 税局机构名称
     */
    private String taxStationName;

    /**
     * 缴税金额
     */
    private BigDecimal vatPayAmt;

    /**
     * 缴税金额币种
     */
    private String vatPayCur;

    /**
     * 增值税注册号
     */
    private String vatRegisteNo;

    /**
     * 锁汇流水号
     */
    private String lockNo;

    /**
     * 缴税寻汇流水号
     */
    private String txnNo;

    /**
     * 手续费金额
     */
    private BigDecimal feeAmt;

    /**
     * 手续费币种
     */
    private String feeCur;

    /**
     * 成交汇率
     */
    private BigDecimal finRate;

    /**
     * 出账金额
     */
    private BigDecimal payAmt;

    /**
     * 出账币种
     */
    private String payCur;

    /**
     * 缴税状态 [A0 审核中 A2 审核通过 A3 审核失败 B1 入账失败 B2 入账成功 S1 出账失败 S2 出账成功]
     */
    private StatusEnum status;

}
