package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsLoanApplyInfoVO implements Serializable {
    private static final long serialVersionUID = -5665391995790310015L;
    /**
     * 贷款申请编号
     */
    private String loanNo;

    /**
     * KYC注册ID
     */
    private String kycNaturalId;

    /**
     * 申请人名称
     */
    private String name;

    /**
     * 申请人手机号
     */
    private String phone;

    /**
     * 意向贷款金额
     */
    private BigDecimal applyAmt;

    /**
     * 实际放款金额
     */
    private BigDecimal realAmt;

    /**
     * 申请贷款时间
     */
    private Date applyDate;

    /**
     * 放款时间
     */
    private Date passDate;

    /**
     * 贷款状态
     */
    private String loanStatus;

    /**
     * 借款天数
     */
    private Integer loanDays;

    /**
     * 综合费率
     */
    private BigDecimal totalRate;

    /**
     * 未还本金
     */
    private BigDecimal unpayPrincipal;

    /**
     * 未还利息
     */
    private BigDecimal unpayInterest;

    /**
     * 未还服务费
     */
    private BigDecimal unpayFee;

    /**
     * 未还罚息
     */
    private BigDecimal unpayPenalty;

    /**
     * 未还提前还款手续费
     */
    private BigDecimal unpayPrepaymentFee;

    /**
     * 已还本金
     */
    private BigDecimal paidPrincipal;

    /**
     * 已还利息
     */
    private BigDecimal paidInterest;

    /**
     * 已还服务费
     */
    private BigDecimal paidFee;

    /**
     * 已还罚息
     */
    private BigDecimal paidPenalty;

    /**
     * 已还提前还款手续费
     */
    private BigDecimal paidPrepaymentFee;

    /**
     * 最早还款时间
     */
    private Date firstRepayTime;

    /**
     * 最晚还款时间
     */
    private Date lastRepayTime;

    /**
     * 还款方式
     */
    private String repayType;

    /**
     * 收款账户id
     */
    private String userAcctId;

    /**
     * 收款账户名称
     */
    private String acctName;

    /**
     * 收款账户号
     */
    private String acctNo;
}