package com.js.common.model.vo;

import com.js.common.enums.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GenerateFileRecordVO implements Serializable {
    private static final long serialVersionUID = -435471727821542936L;

    private String id;
    /**
     * 注册表主键ID
     */
    private String kycNaturalId;

    /**
     * 生成文件编号
     */
    private String generateNo;

    /**
     * 生成类型（GENERATE_TRADE_RECORD-下载交易记录，GENERATE_TRADE_RECEIPT-下载回执单，GENERATE_FUND_RECORD-下载资金记录）
     */
    private GenerateFileType generateType;

    /**
     * 生成起始日期
     */
    private Date generateStartDate;

    /**
     * 生成结束日期
     */
    private Date generateEndDate;

    /**
     * js文件资源表主键ID
     */
    private String commFileId;

    /**
     * '存放路径'
     */
    private String fileSavePath;

    /**
     * '显示名称'
     */
    private String fileShowName;

    /**
     * '下载文件类型'
     */
    private FileType fileType;

    /**
     * '下载文件类型描述'
     */
    private String fileTypeDesc;

    /**
     * '平台'
     */
    private StorePlateformEnum storePlateform;

    /**
     * ''店铺ID''
     */
    private String kycStoreId;

    private String storeName;

    /**
     * '语言类型'
     */
    private LanguageType languageType;

    /**
     * '语言类型描述'
     */
    private String languageTypeDesc;

    /**
     * 入账处理状态(TRADE_UNPROCESSED-生成中，TRADE_PROCESSED-生成完成)
     */
    private ProcessStatusEnum processStatus;

    /**
     * '''交易类型'''
     */
    private TradeTypeEnum tradeType;

    /**
     * '''交易类型描述'''
     */
    private String tradeTypeDesc;

    /**
     * '账号'
     */
    private String acctNo;

    /**
     * '平台名称'
     */
    private String storePlateformName;

    /** 创建日期 */
    private Date createDts;

    private String batchNo;
}