package com.js.common.model.req;

import com.js.common.enums.*;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class JsTradeListReq implements Serializable {
    private static final long serialVersionUID = -1809553630528263895L;
    /**
     * 交易起始日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date tradeStartDate;
    /**
     * 交易结束日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd")
    private Date tradeEndDate;

    /**
     * 平台站点
     */
    private SiteEnum storeTheSite;

    /**
     * 平台
     */
    private StorePlateformEnum storePlateform;

    /**
     * 店铺Id
     */
    private String kycStoreId;

    private String storeName;

    /**
     * 交易类型
     */
    private TradeTypeEnum tradeType;

    private TradeSubTypeEnum tradeSubType;

    /**
     * 下载类型
     */
    private GenerateFileType generateFileType;

    /**
     * 下载文件类型
     */
    private FileType fileType;

    /**
     * 语言类型
     */
    private LanguageType languageType;

    /**
     * 银行账号表主键ID
     */
    private String kycBankId;

    /**
     * 币种
     */
    private String currency;

    private String kycNaturalId;
    private Integer startPage = 0;
    private Integer pageSize = 5;
    /**
     * 交易状态
     */
    private ProcessStatusEnum processStatusEnum;

    /**
     * '账号'
     */
    private String acctNo;

    /**
     * '平台名称'
     */
    private String storePlateformName;

    private String batchNo;
}