package com.js.common.model.req;

import com.js.common.enums.BankAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPayUserAcctReq implements Serializable {
    private static final long serialVersionUID = -798949568538488749L;
    /**
     * 平台类型（HFGJ(汇付国际))
     */
    private SysPlateformType plateformType;

    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 账户类型
     */
    private BankAcctTypeEnum acctType;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户号
     */
    private String acctNo;

    /**
     * 账户余额
     */
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    private BigDecimal lastAmt;

    /**
     * 账户持有人id
     */
    private Integer storeHoldMember;
}