package com.js.common.model.vo;

import com.js.common.enums.BeneficiaryTypeEnum;
import lombok.Data;

import java.io.Serializable;

@Data
public class KycSunrateBeneficiaryVO implements Serializable {
    private static final long serialVersionUID = 8167973975134992290L;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 受益人编号-锁汇成交时使用Key，受益人唯一编号
     */
    private String beneficiaryId;

    /**
     * 受益人状态-0：审核中,1：审核通过,2：审核未通过 
     */
    private String beneficiaryStatus;

    /**
     * 结果通知说明
     */
    private String auditRemark;

    /**
     * 组织机构代码
     */
    private String orgCode;

    /**
     * 国家代码，受益人国家-如：HK、CN、JP，ISO 3166-1 alpha-2
     */
    private String countryCode;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift 
     */
    private String routeType;

    /**
     * ABA
     */
    private String aba;

    /**
     * IBAN
     */
    private String iban;

    /**
     * SWIFTCODE
     */
    private String swiftcode;

    private BeneficiaryTypeEnum beneficiaryType;

    /**
     * 受益人名称
     */
    private String beneficiaryName;

    /**
     * 受益人银行账号，iban 包含账号，此处也需要
     */
    private String beneficiaryAcctNo;

    /**
     * 币种
     */
    private String cur;

    /**
     * 受益人地址
     */
    private String beneficiaryAddr;

    /**
     * 备注
     */
    private String remark;
}