package com.js.common.model.vo;

import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.SexEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName: KycNaturalVO
 * @Description: kycNaturalVO对象
 * @Author: yjzhao
 * @Create: 2019-05-16  10:42
 **/
@Data
public class KycNaturalVO implements Serializable {

    private String id;

    /** 注册类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）*/
    private RegisterType registerType;

    /** 实名名称（类型为个人填写客户姓名，类型为企业填写企业名称） */
    private String certificationName;

    private String idNo;

    /** 注册手机号 */
    private String phoneNo;

    /** 注册邮箱 */
    private String email;

    private SexEnum sex;

    /**
     * 邮箱是否激活(0:未激活, 1:已激活)
     */
    private Boolean emailActiveFlag;

    /**
     * 是否通过经营者备案[1是，0否]
     */
    private Boolean recordFlag;

    /**
     * 实名认证状态
     */
    private CertiStatusEnum certificationStatus;

    /** 备注 */
    private String jsRemark;

    /** 邀请码 */
    private String inviteCode;

    /** 注册id */
    private String createId;

    /** 注册日期 */
    private Date createDts;

    private String updateId;

    /** 更新时间 */
    private Date updateDts;

    private String orgCode;
    private String browserIP;
}
