package com.js.common.model.vo;

import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySysAcctVO implements Serializable {
    private static final long serialVersionUID = 5524819666890525134L;

    private String id;

    /**
     * 平台类型（HFGJ(汇付国际))
     */
    private SysPlateformType plateformType;

    /**
     * 账户类型
     */
    private JsPaySysAcctTypeEnum acctType;

    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户号
     */
    private String acctNo;

    private String idNo;

    /**
     * '收款银行名称'
     */
    private String receivingBankName;

    /**
     * '收款银行地址'
     */
    private String receivingBankAddr;

    /**
     * '收款人地址'
     */
    private String receivingAcctAddr;

    /**
     * 'swiftcode'
     */
    private String swiftCode;

    /**
     * '收款人常驻国家'
     */
    private String receivingAcctCountry;

    /**
     * '收款账户信息'
     */
    private String receivingAcctDesc;

    /**
     * '币种
     */
    private String cur;

    /**
     * 账户余额
     */
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    private BigDecimal lastAmt;

    /**
     * 账户持有人id
     */
    private Integer storeHoldMember;

    /**
     * 是否为当前使用[0:不是, 1:是]
     */
    private Boolean useFlag;

}