package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 总店铺趋势指标。
 *
 * @author liutianyu
 */
@Data
public class JsLoanStatisticsInfoKycVO implements Serializable {
    private static final long serialVersionUID = 8768450746645089749L;


    /**
     * 入账金额
     */
    private BigDecimal monthlyIncome;

    /**
     * 销售额
     */
    private BigDecimal monthlySale;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 订单数量
     */
    private BigDecimal monthlyOrderNum;

    /**
     * 客单价
     */
    private BigDecimal perCustomerTransaction;

    /**
     * SKU
     */
    private BigDecimal averageSkuNum;

    /**
     * 退款率
     */
    private BigDecimal monthlyRefundRate;

    /**
     * 统计时间
     */
    String month;

}
