package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SignContractReq implements Serializable {

    private static final long serialVersionUID = -4620362328976389583L;

    @NotBlank(message = "贷款编号不能为空")
    private String loanNo;
    @NotNull(message = "申请金额不能为空")
    @Min(value = 0,message = "申请金额不能为0")
    private BigDecimal realAmt;
}
