package com.js.common.model.req;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class KycStoreReq implements Serializable{
    private static final long serialVersionUID = -1554709962364051460L;
    /**
     * 店铺名称
     */
    @NotBlank(message = "店铺名称不能为空")
    private String storeName;

    /**
     * 店铺持有人ID
     */
    private String storeHoldPersonId;

    /**
     * 店铺持有人名称
     */
    @NotBlank(message = "店铺持有人名称不能为空")
    private String storeHoldPersonName;

    /**
     * 店铺所在平台名称
     */
    @NotNull(message = "店铺所在平台名称不能为空")
    private StorePlateformEnum storePlateform;

    /**
     * 店铺所在站点
     */
    @NotNull(message = "店铺所在站点CODE编码不能为空")
    private SiteEnum storeTheSite;

    /**
     * 店铺网址
     */
    private String storeUrl;

    /**
     * 店铺情况(1-已有产品售卖,0-暂无产品售卖／暂无店铺)
     */
    @NotNull(message = "店铺情况不能为空")
    private Boolean storeSituation;

    /**
     * 卖家编号
     */
    private String sellId;

    /**
     * MWS授权令牌
     */
    private String mwsAuthToken;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;
}