package com.js.common.model.req;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class KycHolderPersonalReq implements Serializable {
    private static final long serialVersionUID = -5612722675431125694L;
    /**
     * 持有人类型(1-大陆个人，3-香港个人)
     */
    @NotNull(message = "持有人类型不能为空")
    private Integer holderType;

    /**
     * 证件类型
     */
    @NotBlank(message = "证件不能为空")
    private String idType;

    /**
     * 客户真实姓名
     */
    @NotBlank(message = "客户真实姓名不能为空")
    private String cusName;

    /**
     * 客户英文名称
     */
    @NotBlank(message = "客户英文名称名称不能为空")
    private String cusEngName;

    /**
     * 客户地址
     */
    @NotBlank(message = "客户地址不能为空")
    private String cusAddress;

    /**
     * 身份证号
     */
    @NotBlank(message = "身份证号不能为空")
    private String idNo;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;
}