package com.js.common.model.req;

import com.js.common.enums.RegisterType;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 贷款准入
 * zhouyongsheng
 */
@Data
public class JsLoanRiskInfoReq  implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 准入申请编号
     */
    private String riskNo;
    /**
     * KYC注册ID
     */
//    @NotBlank(message = " KYC注册ID不能为空")
    private String kycNaturalId;

    /** KYC类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）*/
//    @NotBlank(message = "KYC类型不能为空")
    private String registerType;

    /**
     * 借款人类型
     * 借款人为企业（1.法人2.持股比例超过51%（含）以上的个人股东）
     *
     */
    @NotBlank(message = "借款人类型不能为空")
    private String borrowerType;

    /**
     * 借款人姓名
     */
    @NotBlank(message = "借款人姓名不能为空")
    private String borrowerName;

    /**
     * 借款人手机号
     */
    @NotBlank(message = "借款人手机号不能为空")
    private String borrowerPhone;

    /**
     * 借款人身份证号
     */
    @NotBlank(message = "借款人身份证号不能为空")
    private String borrowerIdcard;

    /**
     * 借款人身份证正面
     */
    @NotBlank(message = "借款人身份证正面不能为空")
    private String borrowerIdCardFront;
    /**
     * 借款人身份证反面
     */
    @NotBlank(message = "借款人身份证反面不能为空")
    private String borrowerIdCardBack;
    /**
     * 借款人手持身份证
     */
    private String borrowerIdCardHold;
    /**
     * 身份证有效起始日期
     */
    @NotBlank(message = "身份证有效起始日期不能为空")
    private String effectiveStartTime;
    /**
     * 身份证有效截止日期
     */
    @NotBlank(message = "身份证有效截止日期不能为空")
    private String effectiveEndTime;
    /**
     * 是否长期有效
     * 0:非长期，1：长期
     */
    @NotBlank(message = "是否长期有效不能为空")
    private String longFlag;


    /**
     * 借款人邮箱
     */
    @NotBlank(message = "借款人邮箱不能为空")
    private String borrowerEmail;

    /**
     * 借款人婚姻状态
     * 1.已婚 2.未婚 3.离异 4.再婚
     */
    @NotBlank(message = "借款人婚姻状态不能为空")
    private String marriageStatus;

    /**
     * 借款人同事联系方式
     */
    @NotBlank(message = "借款人同事联系方式不能为空")
    private String borrowerColleague;

    /**
     * 借款人现家庭住址
     */
    @NotBlank(message = "借款人现家庭住址不能为空")
    private String borrowerAddress;

    /**
     * 人行征信注册账号
     */
    @NotBlank(message = "人行征信注册账号不能为空")
    private String creditReportingNo;

    /**
     * 人行征信登录密码
     */
    @NotBlank(message = "人行征信登录密码不能为空")
    private String creditReportingPassword;

    /**
     * 人行征信身份验证码
     */
    @NotBlank(message = "人行征信身份验证码不能为空")
    private String creditReportingAuthcode;

    /**
     * 人行征信报告OSS地址
     */
    private String creditReportingOss;

    /**
     * 担保人类型 （1.法人2.持股比例超过51%（含）以上的个人股东）
     */
    @NotBlank(message = "担保人类型不能为空")
    private String guaranteeType;

    /**
     * 担保企业名称
     */
    @NotBlank(message = "担保企业名称不能为空")
    private String guaranteeCorp;

    /**
     * 担保企业统一信用代码
     */
    @NotBlank(message = "担保企业统一信用代码不能为空")
    private String guaranteeCorpOrgcode;

    /**
     * 担保企业实际经营地址
     */
    @NotBlank(message = "担保企业实际经营地址不能为空")
    private String guaranteeCorpAddress;

    /**
     * 担保企业证明材料
     */
    @NotBlank(message = "担保企业证明材料不能为空")
    private String guaranteeCorpQualification;

    /**
     * 担保企业法人身份证正面
     */
    @NotBlank(message = "担保企业法人身份证正面不能为空")
    private String guaranteeLegalnameFront;

    /**
     * 担保企业法人身份证反面
     */
    @NotBlank(message = "担保企业法人身份证正面不能为空")
    private String guaranteeLegalnameBack;

    /**
     * 担保企业法人姓名
     */
    @NotBlank(message = "担保企业法人姓名不能为空")
    private String guaranteeCorpLegalname;

    /**
     * 担保企业法人证件号码
     */
    @NotBlank(message = "担保企业法人证件号码不能为空")
    private String guaranteeCorpIdcard;

    /**
     * 担保企业法人手机号
     */
    @NotBlank(message = "担保企业法人手机号不能为空")
    private String guaranteeCorpPhone;

    /**
     * 担保企业法人邮箱
     */
    @NotBlank(message = "担保企业法人邮箱不能为空")
    private String guaranteeCorpEmail;

    /**
     * 担保企业法人家庭住址
     */
    @NotBlank(message = "担保企业法人家庭住址不能为空")
    private String guaranteeLegalHomeAddress;

    /**
     * 担保企业法人办公地址
     */
    private String guaranteeLegalOfficeAddress;

    /**
     * 企业对公账号
     */
    @NotBlank(message = " 企业对公账号不能为空")
    private String corpAcct;

    /**
     * 对公开户行
     */
    @NotBlank(message = "对公开户行不能为空")
    private String corpAcctBank;

    /**
     * 对公开户行支行
     */
    @NotBlank(message = "对公开户行支行不能为空")
    private String corpAcctBranchBank;

    /**
     * 担保企业法人身份证结束有效期
     */
    @NotBlank(message = "担保企业法人身份证结束有效期不能为空")
    private String guaranteeIdcardEndTime;

    /**
     * 担保企业法人身份证开始有效期
     */
    @NotBlank(message = "担保企业法人身份证开始有效期不能为空")
    private String guaranteeIdcardStartTime;

    /**
     * 担保人省份证是否长期有效0:非长期，1：长期
     */
    @NotBlank(message = "担保人省份证是否长期有效不能为空")
    private String guaranteeLongFlag;

    /**
     * 银行所在省份编码
     */
    @NotBlank(message = "银行所在省份编码不能为空")
    private String corpBankProvinceCode;

    /**
     * 银行所在省份名称
     */
    @NotBlank(message = "银行所在省份名称不能为空")
    private String corpBankProvinceName;

    /**
     * 银行所在城市编码
     */
    @NotBlank(message = "银行所在城市编码不能为空")
    private String corpBankCityCode;

    /**
     * 银行所在城市名称
     */
    @NotBlank(message = "银行所在城市名称不能为空")
    private String corpBankCityName;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空")
    private String corpBankName;

    /**
     * 银行编码
     */
    @NotBlank(message = "银行编码不能为空")
    private String corpBankCode;

    /**
     * 企业对公账号名称
     */
    private String corpAcctName;

    /**
     * 性别
     */
    private String sex;

}