package com.js.common.model.req;

import com.js.common.enums.AmazonEndpointEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class ChinaPNRTransactionDetailsReq implements Serializable {

    /**
     * 用户 kycNaturalId
     */
    @NotBlank
    String kycNaturalId;

    /**
     * 代发时间标志
     */
    @NotBlank
    Date dispaterDate;

    /**
     * 批次号
     */
    String batchNo;

    /**
     * 进入汇付的币种代码（一般是人民币）
     */
    @NotBlank
    String currencyCode;

    /**
     * 要提现的金额（一般是人民币）
     */
    @NotNull
    BigDecimal targetAmount;

    /**
     * 使用的汇率
     *
     * 例：如果源币种为美金。则这里填 6.xxx
     */
    @NotNull
    BigDecimal exchangeRate;

    @NotNull
    private AmazonEndpointEnum amazonEndpointEnum;

}
