package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 汇付代发交易明细
 */
@Data
@ApiModel(value="汇付代发交易明细（ChinaPNRSubstituteDetails）",description="汇付代发交易明细")
public class ChinaPNRSubstituteDetails implements Serializable {

    private static final long serialVersionUID = -1513703756018851418L;

    /**
     * 代发明细流水号
     */
    @ApiModelProperty(value = "代发明细流水号")
    private String substituteDetailId;
    /**
     * 金额
     */
    @ApiModelProperty(value = "金额")
    private BigDecimal substituteDetailAmt;
    /**
     * 收款银行代码
     */
    @ApiModelProperty(value = "收款银行代码")
    private String receivablesBankCode;

    /**
     * 账号
     */
    @ApiModelProperty(value = "账号")
    private String accountNumbe;

    /**
     * 户名
     */
    @ApiModelProperty(value = "户名")
    private String AccountName;

    /**
     * 010 贷款服务本金 020 提现服务 030 汇差 040贷款服务费 050 提现服务费 060贷款服务利息
     */
    @ApiModelProperty(value = "交易类型")
    private String substituteType;

    /**
     *证件类型
     * 00–身份证
     * 01–护照
     * 02–军官证
     * 03–士兵证
     * 04–回乡证
     * 05–户口本
     * 06–外国护照
     * 07–其它个人证件类型
     * 61–组织机构代码证
     * 62–营业执照
     * 63–税务登记证
     * 69–其它机构证件
     */
    @ApiModelProperty(value = "证件类型")
    private String documentType;
    /**
     * 证件号码
     */
    @ApiModelProperty(value = "证件号码")
    private String identificationNumber;

    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private String province;
    /**
     * 地区
     */
    @ApiModelProperty(value = "地区")
    private String region;
    /**
     * 支行名
     */
    @ApiModelProperty(value = "支行名")
    private String branchName;
    /**
     * 用途
     */
    @ApiModelProperty(value = "用途")
    private String purpose;
    /**
     * 出款用户号
     */
    @ApiModelProperty(value = "出款用户号")
    private String paymentOutName;
    /**
     * 收款行联行号
     */
    @ApiModelProperty(value = "收款行联行号")
    private String paymentBank;

    /**
     * 收款账户的类型
     * ‘C’–对公
     * ‘P’–对私
     * ‘H’–汇付内部账户
     */
    @ApiModelProperty(value = "收款账户的类型")
    public String receivablesAccType;
}
