package com.js.common.model.req;

import com.js.common.annotation.Phone;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ApplyWithdrawTotalReq implements Serializable{
    private static final long serialVersionUID = -1554709962364051460L;
    /**
     * 提现总金额
     */
    @NotNull(message = "提现总金额不能为空")
    private BigDecimal withdrawTotalAmt;

    /**
     * 手续费  eg:0.03%
     */
    @NotBlank(message = "手续费不能为空")
    private String serviceCharge ;

    /**
     * 到账币种
     */
    @NotBlank(message = "到账币种不能为空")
    private String currency;

    /**
     * 提现银行卡Id
     */
    @NotBlank(message = "提现银行卡ID不能为空")
    private String bankId;

    /**
     * 提现银行卡号
     */
    @NotBlank(message = "提现银行卡账号不能为空")
    private String accountNo;

    /**
     * 银行卡预留手机号
     */
    @NotNull(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;

    @NotEmpty(message = "提现店铺列表不能为空")
    private List<@Valid ApplyWithdrawReq> withdrawStoreList;
}