package com.js.common.enums;

/**
 * @Author yjzhao
 * @Description 返回码常量
 * @Date 2019/5/15 20:15
 * @Param
 * @return
 **/
public enum ResultEnum {

    /** 常见返回码 Start: 0*/
    SUCCESS(0, "success"),
    ERROR(-999, "error"),
    LOGIN_SUCCESS(1,"登录成功"),
    LOGIN_ERROR(-1, "登陆失败"),
    REGISTE_SUCCESS(2, "注册成功"),
    REGISTE_ERROR(-2, "注册失败"),
    USER_NOT_EXIST(-3, "不存在该用户"),
    USER_DISABLE(-7, "用户已禁用"),
    MESSAGE_NOT_EXIST(-8,"信息不存在"),
    USER_TOKEN_FAILURE(-9, "登陆已失效.请重新登录."),
    FILE_DELETE_SUCCESS(10, "文件删除成功."),
    FILE_DELETE_ERROR(-10, "文件删除失败."),
    FILE_UPLOAD_SUCCESS(11, "文件上传成功."),
    FILE_UPLOAD_ERROR(-11, "文件上传失败."),
    MESSAGE_EXIST(-12,"信息已存在"),
    VALIDATE_CODE_SUCC(13,"验证码验证成功"),
    VALIDATE_CODE_ERROT(-13,"验证码验证失败"),
    USER_DISABLE_ERROR(-14,"用户已禁用"),
    EMAIL_EXISTS_ERROR(-15,"邮箱被占用"),
    MOBILE_EXISTS_ERROR(-16,"手机号被占用"),
    FILE_DOWNLOAD_SUCCESS(17, "文件下载成功."),
    FILE_DOWNLOAD_ERROR(-17, "文件下载失败."),
    SEND_VALIDATE_CODE_SUCCESS(18, "验证码发送成功"),
    SEND_VALIDATE_CODE_ERROR(-18, "验证码发送失败"),
    LOGOUT_SUCCESS(19, "退出成功"),
    LOGOUT_ERROR(-19, "退出失败"),
    PWD_REGEX_ERROR_TWO(20, "两次密码不一致"),
    PWD_REGEX_ERROR(-20, "密码格式错误"),
    EMAIL_REGEX_ERROR(-21, "邮箱格式错误"),
    PHONE_REGEX_ERROR(-22, "手机格式错误"),
    CHANGE_PWD_SUCCESS(23, "更改密码成功"),
    CHANGE_PWD_ERROR(-23, "更改密码失败"),
    VALIDATE_CODE_EXISTS_ERROR(-24, "验证码不能为空"),
    NO_MUST_PARAM_ERROR(-25, "参数不正确"),
    SEND_EMAIL_SUCCESS(26, "发送邮件成功"),
    END_EMAIL_ERROR(-26, "发送邮件失败"),
    EFFECTIVE_TIME_ERROR(-27, "身份证有效截止日期不能小于起始日期"),
    SEND_ALREADY(-28,"信息通知已执行过,请确认"),
    QUERY_PRICE_FAILURE(-29,"询价失败"),
    PWD_NEW_EQUELS_OLD(-30, "新密码与原密码相同！"),
    QUESTION_NEW_EQUELS_OLD(-31, "新问题与原问题相同！"),
    PHONE_NEW_EQUELS_OLD(-32, "新手机号与原手机号相同！"),
    CERTI_ALREADY_SUBMIT(-33, "实名信息已提交！"),
    EMAIL_NOT_ACTIVE(-34, "邮箱未激活！"),
    QUESTION_ANSWER_NOT_EQUALS(-35, "密保答案不正确！"),
    RCV_USER_ALREADY(-36, "收款人已经存在"),
    FILE_GENERATE_ERROR(-37, "文件生成失败."),
    UPDATE_FILE_UNKNOWN(-38, "上传文件与币种选择不符合!"),
    UPDATE_FILE_FIAL_MODEL(-39, "上传文件非原始基础模板文件!"),
    FILE_PREVIEW_SUCCESS(40, "文件预览成功."),
    FILE_PREVIEW_ERROR(-40, "文件预览失败."),

    /** 常见返回码 End: 999*/

    /** 数据操作通用相关 Start: 10001 */
    QUERY_SUCCESS(10001,"查询成功"),
    QUERY_ERROR(-10001,"查询失败"),
    DELETE_SUCCESS(10002,"删除成功"),
    DELETE_ERROR(-10002,"删除失败"),
    UPDATE_SUCCESS(10003,"更新成功"),
    UPDATE_ERROR(-10003,"更新失败"),
    SAVE_SUCCESS(10004,"保存成功"),
    SAVE_ERROR(-10004,"保存失败"),
    ILLEGAL_CHARACTER(-10005, "非法字符，包含敏感字符"),
    /** 数据操作通用相关 End: 20000 */

    /** 系统相关 Start: 100001*/
    SYSTEM_ERROR(-100001,"系统繁忙，请稍后再试"),
    UNKNOW_ERROR(-100002,"未知错误"),

    /** 系统相关 End: 999999 */

    /** js支付 相关错误 Start：1001*/
    GET_PWD_KEY_SUCCESS(1001, "密码加密key获取成功"),
    GET_PWD_KEY_ERROR(-1001, "密码加密key获取失败"),
    CERTI_FAILURE(-1002, "实名认证失败,暂不可以申请收款账户"),
    CERTI_WATRING(-1003, "实名认证未完成,暂不可以申请收款账户"),
    AUDIT_STORE_NOT_COMPLETE(-1004, "存在审核未完成店铺,请等待完成后再次申请"),
    CHECK_AUTH_TOKEN_SUCCESS(1005, "店铺授权信息校验通过"),
    CHECK_AUTH_TOKEN_FAILURE(-1005, "店铺授权信息校验失败"),
    BANK_CHECK_SUCCESS(1006, "银行卡要素验证成功"),
    BANK_CHECK_FAILURE(-1006, "银行卡要素验证失败"),
    ALREADY_TO_MAX_APPLY_COUNT(-1007, "暂无店铺申请收款账户已经达到最大限制，请授权未授权的店铺"),
    STORE_TOKEN_DUPLICATE(-1008, "同一平台大区下店铺授权 token 不允许重复"),
    /** js支付 相关错误 End：2000*/
    /** js借贷 相关错误 Start：2001*/
    FADADA_OPEN_ACCOUTN_SUCCESS(2001, "法大大开户成功"),
    FADADA_OPEN_ACCOUTN_FAILURE(-2001, "法大大开户失败"),
    FADADA_PERSON_DEPOSIT_SUCCESS(2002, "法大大个人实名认证信息成功"),
    FADADA_PERSON_DEPOSIT_FAILURE(-2002, "法大大个人实名认证信息失败"),
    FADADA_COMPANY_DEPOSIT_SUCCESS(2003, "法大大个人实名认证信息成功"),
    FADADA_COMPANY_DEPOSIT_FAILURE(-2003, "法大大个人实名认证信息失败"),
    FADADA_APPLAY_CA_SUCCESS(2004, "法大大编号证书申请成功"),
    FADADA_APPLAY_CA_FAILURE(-2004, "法大大编号证书申请失败"),
    FADADA_CUSTOM_SIGNATURE_SUCCESS(2005, "法大大自定义印章成功"),
    FADADA_CUSTOM_SIGNATURE_FAILURE(-2005, "法大大自定义印章失败"),
    FADADA_ADD_SIGNATURE_SUCCESS(2006, "法大大上传印章成功"),
    FADADA_ADD_SIGNATURE_FAILURE(-2006, "法大大上传印章失败"),
    FADADA_UPLOAD_CONTRACT_SUCCESS(2007, "法大大合同上传成功"),
    FADADA_UPLOAD_CONTRACT_FAILURE(-2007, "法大大合同上传失败"),
    FADADA_SIGN_CONTRACT_SUCCESS(2008, "法大大合同签署成功"),
    FADADA_SIGN_CONTRACT_FAILURE(-2008, "法大大合同签署失败"),
    FADADA_SIGN_CONTRACT_NUM_FAILURE(-2009, "法大大上传合同数量不匹配"),
    FADADA_ARCHIVE_CONTRACT_SUCCESS(2010, "法大大合同归档成功"),
    FADADA_ARCHIVE_CONTRACT_FAILURE(-2010, "法大大合同归档失败"),
    LOAN_APPLY_INFO_RISK_QUOTA_FAILURE(-2011, "风控指标计算失败"),
    FADADA_PERSON_DEPOSIT_VALIDATE_FAILURE(-2012, "准入借款人 kycId，姓名，身份证号。借款申请中的手机号收款账号不可以为空"),
    FADADA_COMPANY_DEPOSIT_VALIDATE_FAILURE(-2013, "准入 kycId，担保企业统一信用代码不可以为空"),
    FADADA_COMPANY_DEPOSIT_HK_VALIDATE_FAILURE(-2014, "准入 kycId 不可为空"),
    QICHACHA_QEQUEST_FAILURE(-2015, "企查查请求发送失败"),
    FADADA_UN_SIGN_VALIDATE_FAILURE(-2016, "法大大获取未签署合同，参数 loanNo 不可以为空"),
    FADADA_SIGN_CONTRACT_SUCCESS2(2017, "本次合同签署完成，请关闭该页面。返回大麦及时雨继续签署流程。"),
    FADADA_SIGN_CONTRACT_FAILURE2(-2017, "合同摘要错误"),
    QICHACHA_ATTACH_ENTERPRISE_FAILURE(-2018, "关联企业查询深度出错"),
    QICHACHA_ATTACH_ENTERPRISE_PARTNER_FAILURE(-2019, "关联企业股东查询深度出错"),
    QICHACHA_ATTACH_ENTERPRISE_PARTNER_VALIDATE_FAILURE(-2020, "关联企业股东查参数错误"),
    QICHACHA_ATTACH_ENTERPRISE_PARTNER_VALIDATE_FAILURE2(-2021, "关联企业股东占比与公司占比不可以超过1"),
    /** js借贷 相关错误 End：3000*/

    /**汇付支付相关 Start: 4001*/
    CHINA_PNR_SUCCESS(4001, "汇付支付成功"),
    CHINA_PNR_ERROR(-4001, "汇付支付失败"),
    CHINA_PNR_OPEND_ACCOUNT_SUCCESS(4002, "开户申请成功"),
    CHINA_PNR_OPEND_ACCOUNT_ERROR(-4002, "开户失败"),
    CHINA_PNR_TRANSACTION_DETAIL_SUCCESS(4003, "交易明细备案成功"),
    CHINA_PNR_TRANSACTION_DETAIL_ERROR(-4003, "交易明细备案失败"),
    CHINA_PNR_TRANSACTION_CONTRAST_SUCCESS(4003, "交易订单还原成功"),
    CHINA_PNR_TRANSACTION_CONTRAST_ERROR(-4003, "交易订单还原失败"),
    CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_SUCCESS(4004, "交易明细备案回调成功"),
    CHINA_PNR_TRANSACTION_DETAIL_CALLBACK_ERROR(-4004, "交易明细备案回调失败"),
    CHINA_PNR_ACC_AMT_SUCCESS(4005,"主账号查询成功"),
    CHINA_PNR_ACC_AMT_ERROR(-4005,"主账号查询失败"),
    CHINA_PNR_EXCHANGE_SUCCESS(4006,"结汇回调成功"),
    CHINA_PNR_EXCHANGE_ERROR(-4006,"结汇回调失败"),
    CHINA_PNR_TRANSACTION_REPORT_ERROR(-4007, "订单还原报告无记录，暂无可使用资金。")
    /** 汇付支付相关 End: 5000*/
    ;

    private Integer code;

    private String msg;

    ResultEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
