package com.js.common.model.vo;

import com.js.common.enums.CertiFileType;
import lombok.Data;

import java.io.Serializable;

@Data
public class KycCertiLinkFileVO implements Serializable {
    private static final long serialVersionUID = 86214020057723744L;
    /**
     * 注册表主键ID
     */
    private String kycNaturalId;

    /**
     * 主表主键ID（大陆个人，大陆企业，香港个人，香港企业表主键）
     */
    private String priId;

    /**
     * js文件资源表主键ID
     */
    private String commFileId;

    /**
     * 存放位置
     */
    private String fileSavePath;

    /**
     * 显示位置
     */
    private String fileShowPath;

    /**
     * 存放名称
     */
    private String fileSaveName;

    /**
     * 显示名称
     */
    private String fileShowName;

    /**
     * 文件缩略图存放地址
     */
    private String fileThumbnailPath;

    /**
     * 文件扩展名
     */
    private String fileExt;

    /**
     * 文件归类组名
     */
    private String fileGroup;

    /**
     * 文件具体类型
     */
    private CertiFileType fileType;

    /**
     * 是否上传到提供方sftp服务器上（0未上传，1已上传）
     */
    private Boolean uploadSftpFlag;

    /**
     * 上传路径
     */
    private String uploadDirc;

}