package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SunrateMarketRateTradeReq implements Serializable {
    private static final long serialVersionUID = 1;
    /**
     * 锁汇编号
     */
    private String lockNo;
    /**
     * 受益人编号-锁汇成交时使用Key，受益人唯一编号
     */
    private String beneficiaryId;
    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 店铺编号
     */
    @NotBlank(message = "店铺编号不能为空")
    private String subAcctNo;

    /**
     * 买入币种
     */
    @NotBlank(message = "买入币种不能为空")
    private String buyCur;

    /**
     * 卖出币种
     */
    @NotBlank(message = "卖出币种不能为空")
    private String sellCur;

    /**
     * 交易模式
     */
    @NotBlank(message = "交易模式不能为空")
    private String txnMode;

    /**
     * 交易金额
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal txnAmt;

    /**
     * 交割日期 yyyy-MM-dd
     */
    @NotBlank(message = "交割日期不能为空")
    private String valueDate;

    /**
     * 客户端浏览器IP
     */
//    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;
}