package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 需还款请求列表
 */
@Data
public class RepaymentLoanReq implements Serializable {
    private static final long serialVersionUID = 122173851639481470L;

    /**
     *  KYC用户ID
     */
    private String kycNaturalId;
    /**
     *  还款开始时间
     */
    private Date repayStartTime;
    /**
     *  还款结束时间
     */
    private Date repayEndTime;

    /**
     *  还款期限开始时间
     */
    private Date repayTermStartTime;

    /**
     *  还款结束时间
     */
    private Date repayTermEndTime;

    private int pageNum=1;

    private int pageSize=10;

}
