package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class QiChaChaEnterpriseInfoReq implements Serializable {

    /**
     * 关键字（注册号、公司名、社会统一信用代码、KeyNo）
     */
    @NotBlank
    String keyWord;

    /**
     * 是否强制使用请求三方接口
     * 默认情况下如果系统中已经存在查询数据将不会请求第三方接口。
     */
    Boolean force = false;

    /**
     * 是否使用真实接口，默认 false
     *
     * 不使用的话，默认返回源奉相关
     */
    Boolean userReal = false;

}
