package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


@Data
public class KycCertiLinkFileReq implements Serializable {
    private static final long serialVersionUID = -2120932579744407535L;
    /**
     * 文件ID
     */
    @NotBlank(message = "文件ID不能为空")
    private String id;

    /**
     * 存放位置
     */
    @NotBlank(message = "文件存放位置不能为空")
    private String fileSavePath;

    /**
     * 显示位置
     */
    @NotBlank(message = "文件显示位置不能为空")
    private String fileShowPath;

    /**
     * 存放名称
     */
    @NotBlank(message = "文件存放名称不能为空")
    private String fileSaveName;

    /**
     * 显示名称
     */
    @NotBlank(message = "文件显示名称不能为空")
    private String fileShowName;

    /**
     * 文件缩略图存放地址
     */
    private String fileThumbnailPath;

    /**
     * 文件扩展名
     */
    @NotBlank(message = "文件扩展名不能为空")
    private String fileExt;

    /**
     * 实名认证上传图片类型
     */
    @NotNull(message = "实名认证图片类型不能为空")
    private CertiFileType certiFileType;

    /**
     * 是否上传到提供方sftp服务器上（false未上传，true已上传）
     */
    private Boolean uploadSftpFlag;

    /**
     * 上传路径
     */
    private String uploadDirc;
}
