package com.js.common.model.req;

import com.js.common.enums.CertiFileType;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class KycCertiHKPersonalReq implements Serializable {
    private static final long serialVersionUID = 1971421921689248024L;

    private String id;
    /**
     * 寻汇返回注册编号key
     */
    private String registerId;

    /**
     * 实名表主键ID
     */
    private String kycCertiId;

    /**
     * 证件类型编码
     */
    @NotNull(message = "证件类型CODE不能为空")
    private CertiFileType certiCardType;

    /**
     * 真实姓名
     */
    @NotBlank(message = "真实姓名不能为空")
    private String cusName;

    /**
     * 英文名称
     */
    @NotBlank(message = "英文名称不能为空")
    private String cusEngName;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    private String certificateNo;

    /**
     * 地址
     */
    @NotBlank(message = "地址不能为空")
    private String address;

    /**
     * 店铺主要经营类别表ID
     */
    @NotBlank(message = "店铺主要经营类别ID不能为空")
    private String storeBusinessTypeId;

    /**
     * 店铺主要经营类别名称
     */
    @NotBlank(message = "店铺主要经营类别名称不能为空")
    private String storeBusinessTypeName;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;
}