package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsTradeReq  implements Serializable {

    private static final long serialVersionUID = 2501436315076651449L;

    /**
     * 外部交易单号
     */
    private String tradeNo;

    /**
     * 账户类型 1.寻汇，2.汇付
     */
    private String accType;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费,5:vat,6:供应商付款,7:放款]
     */
    private String tradeSubType;

    /**
     * 币种
     */
    private String curId;

    /**
     * 交易金额
     */
    private BigDecimal tradeAmt;


    /**
     * 交易时间
     */
    private Date tradeDts;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    private String processStatus;

    /**
     * 记账账户号A
     */
    private String acctA;

    /**
     * 账户名称A
     */
    private String acctNameA;

    /**
     * 记账账户号B
     */
    private String acctB;

    /**
     * 账户名称B
     */
    private String acctNameB;

    /**
     * 用户主体A
     */
    private String kycNaturalIdA;

    /**
     * 用户主体B
     */
    private String kycNaturalIdB;

}