package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 代发查询请求实体
 */
@Data
@ApiModel(value="代发查询请求实体（ChinaPNRSubstituteQueryReq）",description="代发查询请求实体")
public class ChinaPNRSubstituteQueryReq implements Serializable {
    private static final long serialVersionUID = -1513703756018851418L;

    /**
     * 请求流水号
     */
    @NotBlank(message = "请求流水号不能为空")
    @ApiModelProperty(value = "请求流水号")
    private String requestId;
    /**
     * 批次号
     */
    @NotBlank(message = "批次号不能为空")
    @ApiModelProperty(value = "批次号")
    private String batchNo;
    /**
     * 交易明细流水号
     */
    @NotBlank(message = "交易明细流水号不能为空")
    @ApiModelProperty(value = "交易明细流水号")
    private String remitNo;
    /**
     * 原批次申请日期
     * yyyyMMdd例如：20180920
     */
    @NotBlank(message = "申请日期不能为空")
    @ApiModelProperty(value = "原批次申请日期")
    private String applyDate;
}
