package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 流水表交易类型
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Getter
public enum TradeSubTypeEnum {
    TRADE_IN(0, "大账户入账"),
    SUB_TRADE_IN(1, "入账"),
    WITHDRAW(2, "提现"),
    WITHDRAW_FEE(3, "提现手续费"),
    LATE_FEE(4, "逾期费"),
    VAT_PAYMENT(5, "VAT缴税"),
    PAY_SUPPLIER(6, "供应商付款"),
    RATE(7, "汇差"),
    REPAYMENT_AUTOMATIC(8, "自动还款"),
    REPAYMENT_ADVANCE(9, "提前还款"),
    REPAYMENT_OVERDUE(10, "逾期还款"),
    ;
    /** 编码 */
    private Integer code;
    /** 说明 */
    private String desc;

    TradeSubTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
