package com.js.common.enums;

import com.js.common.util.DbEnum;
import lombok.Getter;

@Getter
public enum StatusEnum implements DbEnum {
    AUDITING("A0", "审核中"),
    AUDITSUCC("A2", "审核成功"),
    AUDITFAIL("A3", "审核失败"),
    RATETRADEING("B0", "换汇中"),
    RATETRADEFAIL("B1", "换汇失败"),
    RATETRADESUCC("B2", "换汇成功"),
    TRADEUNKNOWN("S0", "交易处理中"),
    OUTTRADEFAIL("S1", "出账失败"),
    OUTTRADESUCC("S2", "出账成功"),
    ;

    private String enumCode;

    private String enumName;

    StatusEnum(String enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }

    @Override
    public String queryEnumCode() {
        return this.enumCode;
    }

    @Override
    public String keyName() {
        return this.enumName;
    }

    @Override
    public String toString() {
        return this.enumName;
    }

}
