package com.js.common.enums;

/**
 * @Author liuh
 * @Description 平台第三方账户类型
 * @Date 2019/6/20
 **/
public enum JsPaySysAcctTypeEnum {

    NONE_TYPE(0,"暂无确定类型"),
    HFGJ_YFJS(1, "汇付国际-源奉济生大账户类型"),
    HFGJ_YFJS_RATE(2, "汇付国际-源奉济生汇差账户类型"),
    HFGJ_YFJS_POUNDAGE(3, "汇付国际-源奉济生手续费账户类型"),
    HFGJ_YFJS_SERVICE_FEE(4, "汇付国际-源奉济生服务费账户类型"),
    HFGJ_YFJS_BENEFICIARY(5, "汇付国际-源奉济生受益人账户"),
    ;

    private Integer code;
    private String desc;

    JsPaySysAcctTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
