package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 国名简称
 * @Author: liwm
 * @Create: 2019-06-27
 **/
@Getter
public enum CountryCodeEnum {
    ENGLAND ("UK", "英国"),
    GERMANY ("DE", "德国"),
    FRANCE ("FR", "法国"),
    ITALY ("IT", "意大利"),
    SPAIN ("ES", "西班牙"),
    ;
    /** 简称 */
    private String enumCode;
    /** 国名 */
    private String enumName;

    CountryCodeEnum(String enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }
}
