package com.js.common.enums;

/**
 * 亚马逊各地区端口
 *
 * 数据主要取自：http://docs.developer.amazonservices.com/en_US/dev_guide/DG_Endpoints.html
 */
public enum AmazonEndpointEnum {
    BRAZIL("Brazil", "BR", "https://mws.amazonservices.com", "A2Q3Y263D00KWC"
            , "", "", ""),
    CANADA("Canada", "CA", "https://mws.amazonservices.ca", "A2EUQ1WTGCTBG2",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.ca"),
    MEXICO("Mexico", "MX", "https://mws.amazonservices.com.mx", "A1AM78C64UM0Y8",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.com.mx"),
    US("US", "US", "https://mws.amazonservices.com", "ATVPDKIKX0DER",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.com"),
    UNITED_ARAB_EMIRATES ("UnitedArabEmirates", "AE", "https://mws.amazonservices.ae", "A2VIGQ35RCS4UG",
            "", "", ""),
    GERMANY("Germany", "DE", "https://mws-eu.amazonservices.com", "A1PA6795UKMFR9",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.de"),
    SPAIN("Spain", "ES", "https://mws-eu.amazonservices.com", "A1RKKUPIHCS9HS",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.es"),
    FRANCE("France", "FR", "https://mws-eu.amazonservices.com", "A13V1IB3VIYZZH",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.fr"),
    UK("UK", "GB", "https://mws-eu.amazonservices.com", "A1F83G8C2ARO7P",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.co.uk"),
    INDIA("India", "IN", "https://mws.amazonservices.in", "A21TJRUUN4KGV",
            "", "", ""),
    ITALY("Italy", "IT", "https://mws-eu.amazonservices.com", "APJ6JRA9NG5V4",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.it"),
    TURKEY("Turkey", "TR", "https://mws-eu.amazonservices.com", "A33AVAJ2PDY3EV",
            "", "", ""),
    AUSTRALIA("Australia", "AU", "https://mws.amazonservices.com.au", "A39IBJ37TRP1C6",
            "", "", ""),
    JAPAN("Japan", "JP", "https://mws.amazonservices.jp", "A1VC38T7YXB528",
            "AKIAJQEPHR5DFUMQSHAA", "L5+FXpjhWhWa7C3uxYFjs7JB/kx8ZBv3FP9BGsP7", "Amazon.co.jp"),
    CHINA("China", "CN", "https://mws.amazonservices.com.cn", "AAHKV2X7AFYLW",
            "", "", "");

    /**
     * 市场
     */
    String marketplace;
    /**
     * 国家代码
     */
    String countryCode;
    /**
     * 服务接口地址
     */
    String endpoint;
    /**
     * 市场 code
     */
    String marketPlaceId;
    /**
     * 开发者 key
     */
    String accessKey;
    /**
     * 开发者密钥
     */
    String secrectKey;
    /**
     * 市场名称
     */
    String marketplaceName;

    AmazonEndpointEnum(String marketplace, String countryCode, String endpoint, String marketPlaceId, String accessKey,
                       String secrectKey, String marketplaceName) {
        this.marketplace = marketplace;
        this.countryCode = countryCode;
        this.endpoint = endpoint;
        this.marketPlaceId = marketPlaceId;
        this.accessKey = accessKey;
        this.secrectKey = secrectKey;
        this.marketplaceName = marketplaceName;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public String getMarketPlaceId() {
        return marketPlaceId;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public String getSecrectKey() {
        return secrectKey;
    }

    public String getMarketplaceName() {
        return marketplaceName;
    }
}
