package com.js.common.config.aliyun;

import com.aliyun.oss.OSSClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass({OSSClient.class})
@EnableConfigurationProperties({AliyunOSSProperties.class})
public class AliyunOSSAutoConfig {

    @Autowired
    AliyunOSSProperties aliyunOSSProperties;

    @Bean
    public AliyunOSSClientFactoryBean ossClientFactoryBean(){
        final AliyunOSSClientFactoryBean factoryBean = new AliyunOSSClientFactoryBean();
        factoryBean.setEndpoint(this.aliyunOSSProperties.getEndpoint());
        factoryBean.setAccessKeyId(this.aliyunOSSProperties.getAccessKeyId());
        factoryBean.setAccessKeySecret(this.aliyunOSSProperties.getAccessKeySecret());
        return factoryBean;
    }

}
