package com.js.common.util;

import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;

import java.io.Serializable;

/**
 * @Author yjzhao
 * @Description 返回工具类
 * @Date 2019/5/23 15:08
 * @Param 
 * @return 
 **/
public class ResultUtil implements Serializable {


    public static ResponseMessage success(Object object, Integer code, String msg) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(code);
        responseMessage.setMsg(msg);
        responseMessage.setData(object);
        responseMessage.setSuccess(true);
        return responseMessage;
    }

    public static ResponseMessage success(Object object, ResultEnum resultEnum) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(resultEnum.getCode());
        responseMessage.setMsg(resultEnum.getMsg());
        responseMessage.setData(object);
        responseMessage.setSuccess(true);
        return responseMessage;
    }


    public static ResponseMessage success(Object object) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(ResultEnum.SUCCESS.getCode());
        responseMessage.setMsg(ResultEnum.SUCCESS.getMsg());
        responseMessage.setData(object);
        responseMessage.setSuccess(true);
        return responseMessage;
    }

    public static ResponseMessage success(ResultEnum resultEnum) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(resultEnum.getCode());
        responseMessage.setMsg(resultEnum.getMsg());
        responseMessage.setSuccess(true);
        return responseMessage;
    }

    public static ResponseMessage success(Integer code,String msg) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(code);
        responseMessage.setMsg(msg);
        responseMessage.setSuccess(true);
        return responseMessage;
    }

    /**
     * 操作成功不返回消息
     * @return
     */
    public static ResponseMessage success() {
        return success(null);
    }

    /**
     * 操作失败返回的消息
     * @param code
     * @param msg
     * @return
     */
    public static ResponseMessage error(int code,String msg) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(code);
        responseMessage.setMsg(msg);
        responseMessage.setSuccess(false);
        return responseMessage;
    }

    /**
     * 操作失败返回消息，对error的重载
     * @param resultEnum
     * @return
     */
    public static ResponseMessage error(ResultEnum resultEnum){
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(resultEnum.getCode());
        responseMessage.setMsg(resultEnum.getMsg());
        responseMessage.setSuccess(false);
        return responseMessage;
    }

    /**
     * 操作失败返回消息，对error的重载
     * @param resultEnum
     * @return
     */
    public static ResponseMessage error(Object object, ResultEnum resultEnum){
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setCode(resultEnum.getCode());
        responseMessage.setMsg(resultEnum.getMsg());
        responseMessage.setData(object);
        responseMessage.setSuccess(false);
        return responseMessage;
    }



}
