package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class KycStoreVO implements Serializable {
    private static final long serialVersionUID = 8393887146267835955L;
    /**
     * js店铺表主键ID
     */
    private String storeId;
    /**
     * 店铺名称
     */
    private String storeName;
    /**
     * 店铺持有人名称
     */
    private String storeHoldPersonName;
    /**
     * 入账时间
     */
    private Date entryDatetime;

    /**
     * 可提现金额
     */
    private BigDecimal withdrawAmount;

    /**
     * 店铺状态[0:未绑定, 1:已绑定]
     */
    private Boolean status;

    /**
     * 店铺授权状态[授权状态：0：未授权 1：已经授权但调用失败 2:已经授权但没有确认第一笔回款 3：已授权且收到了回款 4：授权被取消']
     */
    private Integer authStatus;

    /**
     * 店铺所在平台ID
     */
    private String storePlateformCode;

    /**
     * 店铺所在平台名称
     */
    private String storePlateformName;

    /**
     * 店铺所在站点CODE编码
     */
    private String storeTheSiteCode;

    /**
     * 店铺所在站点名称
     */
    private String storeTheSiteName;

    /**
     * 店铺网址
     */
    private String storeUrl;

    /**
     * 币种符号
     */
    private String currencySymbol;

    /**
     * 店铺审核状态
     */
    private String auditStatus;
    /**
     * 店铺审核备注
     */
    private String auditRemark;
    /**
     * 店铺审核时间
     */
    private Date auditDts;
}