package com.js.common.model.vo;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySysAcctVO implements Serializable {
    private static final long serialVersionUID = 5524819666890525134L;
    /**
     * 支付平台(1:汇付,2:富友,3:宝付)
     */
    private String acctType;

    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户号
     */
    private String acctNo;

    /**
     * 账户余额
     */
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    private BigDecimal lastAmt;

    /**
     * 账户持有人id
     */
    private Integer storeHoldMember;

    /**
     * 是否为当前使用[0:不是, 1:是]
     */
    private Boolean useFlag;

}