package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 借货用户实时统计信息。
 *
 * @author liutianyu
 */
@Data
public class JsLoanStatisticsInfoVO implements Serializable {
    private static final long serialVersionUID = 3669134078338733534L;

    /**
     * 取消授权店铺占比
     */
    BigDecimal cancelAuthRatio;
    /**
     *关闭店铺占比
     */
    BigDecimal shutdownRatio;
    /**
     *店铺数量
     */
    BigDecimal storeNum;
    /**
     *授权成功的店铺数量
     */
    BigDecimal authAndAuthWithAccount;
    /**
     * 绑定回款账户与授权店铺的比例
     */
    BigDecimal authAndAuthWithAccountRatio;
}
