package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 借货用户店铺信息。
 * @author liutianyu
 */
@Data
public class JsLoanStatisticsInfoStoreVO implements Serializable {
    private static final long serialVersionUID = 5326325181544453258L;

    /**
     * 月均销售额（美元）
     */
    BigDecimal monthlySale;

    /**
     * 退款率环比波动率
     */
    BigDecimal refundChainRate;

    /**
     * 在售商品数量环比波动率
     */
    BigDecimal availableProductNumChainRate;

    /**
     * 销售额前10名商品占比
     */
    BigDecimal salesTopTenRatio;

    /**
     * 销售额前3名商品占比
     */
    BigDecimal salesTopThreeRatio;

    /**
     * 月均入账金额（美元）
     */
    BigDecimal monthlyIncome;

    /**
     * 绑定回款账户时长(月)
     */
    BigDecimal bindTime;

    /**
     * 入账金额
     */
    BigDecimal income;

    /**
     * 笔均入账金额
     */
    BigDecimal averageIncome;

    /**
     * 近一个月入账金额环比增长率
     */
    BigDecimal incomeChainRate;

    /**
     * 近一个月入账金额与前3个月平均入账金额比例
     */
    BigDecimal incomeThreeRatio;

    /**
     * 近一个月入账金额与前6个月平均入账金额比例
     */
    BigDecimal incomeSixRatio;

    /**
     * 入账金额同比增长率
     */
    BigDecimal incomeGrowthRateOnYear;
    /**
     * 统计时间
     */
    Date statisticsTime;

    /**
     * 授权状态
     */
    Integer authStatus;

    /**
     * 店铺 id
     */
    String storeId;

    /**
     * 店铺名称
     */
    String storeName;
}
