package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 借货用户维度店铺信息。
 *
 * @author liutianyu
 */
@Data
public class JsLoanStatisticsInfoKycVO implements Serializable {
    private static final long serialVersionUID = 8768450746645089749L;


    /**
     * 亚马逊美国店铺近半年销售额占比（授权成功）
     */
    BigDecimal halfYearSaleRatio;

    /**
     * 月均销售额（美元）
     */
    BigDecimal monthlySale;

    /**
     * 月均入账金额（美元）
     */
    BigDecimal monthlyIncome;

    /**
     * 近一个月入账金额环比增长率
     */
    BigDecimal incomeChainRate;

    /**
     * 近一个月入账金额与前3个月平均入账金额比例
     */
    BigDecimal incomeThreeRatio;

    /**
     * 近一个月入账金额与前6个月平均入账金额比例
     */
    BigDecimal incomeSixRatio;

    /**
     * 入账金额同比增长率
     */
    BigDecimal incomeGrowthRateOnYear;

    /**
     * 统计时间
     */
    Date statisticsTime;

    /**
     * 用户 id
     */
    String kycNaturalId;

}
