package com.js.common.model.req;

import com.js.common.annotation.Phone;
import lombok.Data;

import javax.validation.constraints.*;
import java.io.Serializable;

/**
 * @ClassName: RegiserKycNaturalReq
 * @Description: 注册请求对象
 * @Author: yjzhao
 * @Create: 2019-05-16  10:06
 **/
@Data
public class  RegiserKycNaturalReq implements Serializable {


    /** 手机号 */
    @NotBlank(message = "手机号不能为空.")
    @Phone
    private String phoneNo;

    /** 注册邮箱 */
    @NotBlank(message = "请填写邮箱.")
//    @Email(regexp = "^[A-Za-z0-9\\u4e00-\\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$",message = "邮箱格式不正确")
    private String email;

    /** 密码 */
    @NotBlank(message = "请填写密码.")
    @Pattern(regexp = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$",message = "登录密码格式不正确")
    private String password;

    /** 确认密码 */
    @NotBlank(message = "请填写确认密码.")
    @Pattern(regexp = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$",message = "确认密码格式不正确")
    private String confirmPassword;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;
}
