package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class KycSunrateStoreReq implements Serializable {
    private static final long serialVersionUID = -1181581478336010420L;
    /**
     * 组织机构代码-识别客户
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 店铺所在站点名称（美国站 USD，日本站 JPY，欧洲站 EUR，英国站 GB）
     */
    @NotBlank(message = "店铺所在站点名称不能为空")
    private String curId;

    /**
     * 店铺名称
     */
    @NotBlank(message = "店铺名称不能为空")
    private String storeName;

    /**
     * 店铺网址
     */
    private String storeUrl;

    /**
     * 店铺平台（01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari ）
     */
    @NotBlank(message = "店铺平台不能为空")
    private String storePlateform;

    /**
     * 卖家ID
     */
    private String sellerId;

//    /**
//     * AWS 访问 Key(AKIAJJSMHVJAFRKNERIA)
//     */
//    private String accessKey;
//
//    /**
//     * 私有秘钥（3ZvKcmoEQLDfE9AUX8MRsPGfOzc6m5CGlBnEqhPg）
//     */
//    private String secretKey;
//
//    /**
//     * 销售商品
//     */
//    private String sellGoods;
//
//    /**
//     * 运营时间
//     */
//    private Date runTime;
//
//    /**
//     * 预估月收款总额-单位（万美元）
//     */
//    private BigDecimal monthAmt;

    private String kycStoreId;
    private String subAcctNo;
}