package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class KycStoreEditReq implements Serializable{
    private static final long serialVersionUID = -1554709962364051460L;
    /**
     * 店铺表主键ID
     */
    @NotBlank(message = "店铺主键不能为空")
    private String kycStoreId;

    /**
     * 店铺名称
     */
    @NotBlank(message = "店铺名称不能为空")
    private String storeName;

    /**
     * 店铺网址
     */
    @NotBlank(message = "店铺链接不能为空")
    private String storeUrl;

    /**
     * 卖家编号
     */
    @NotBlank(message = "卖家编号不能为空")
    private String sellId;

    /**
     * MWS授权令牌
     */
    @NotBlank(message = "MWS Auth Token不能为空")
    private String mwsAuthToken;
}