package com.js.common.model.req;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
public class KycHolderCompanyReq implements Serializable {
    private static final long serialVersionUID = -9134115785473167402L;
    /**
     * 持有人类型(2-大陆企业，4-香港企业)
     */
    @NotNull(message = "持有人类型不能为空")
    private Integer holderType;

    /**
     * 企业名称
     */
    @NotBlank(message = "企业名称不能为空")
    private String companyName;

    /**
     * 企业英文名称
     */
    @NotBlank(message = "企业英文名称不能为空")
    private String companyEngName;

    /**
     * 企业地址
     */
    @NotBlank(message = "企业地址不能为空")
    private String companyAddress;

    /**
     * 附件集合
     */
    @NotEmpty(message = "请上传附件信息")
    private List<@Valid KycCertiLinkFileReq> kycCertiLinkFileReqList;
}