package com.js.common.model.req;

import com.js.common.annotation.Phone;
import com.js.common.enums.BankAreaType;
import com.js.common.enums.BankAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

@Data
public class KycBankReq implements Serializable {
    private static final long serialVersionUID = -4338274747671397115L;

    /**
     * 银行卡用户名
     */
    @NotBlank(message = "银行卡户名不能为空.")
    private String accountName;

    /**
     * 账号币种
     */
    @NotBlank(message = "账号币种不能为空.")
    private String currencyCode;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空.")
    private String accountNo;

    /**
     * swiftCode
     */
    private String swiftCode;

    /**
     * 银行卡预留手机号
     */
    @NotBlank(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    /**
     * 银行卡所属地域
     */
    @NotNull(message = "银行卡所属地区不能为空.")
    private BankAreaType stateOrRegion;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空.")
    private String bankName;

    /**
     * 银行编码
     */
    private String bankCode;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;

    /**
     * 银行所在省份Code
     */
//    @NotBlank(message = "银行所在省份Code不能为空.")
    private String provinceCode;

    /**
     * 银行所在省份名称
     */
//    @NotBlank(message = "银行所在省份名称不能为空.")
    private String provinceName;

    /**
     * 银行所在市Code
     */
//    @NotBlank(message = "银行所在市Code不能为空.")
    private String cityCode;

    /**
     * 银行所在市名称
     */
//    @NotBlank(message = "银行所在市名称不能为空.")
    private String cityName;

    /**
     * 银行支行名称
     */
//    @NotBlank(message = "银行支行名称不能为空.")
    private String bankBranchName;

    /**
     * 银行支行行号
     */
    private String bankBranchCode;

    /**
     * 开对公户时账户类型
     */
    private BankAcctTypeEnum companyAcctType;

    /**
     * 渠道类型
     */
    private SysPlateformType routeType;
}