package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.enums.TradeSubTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class JsTradeListReq implements Serializable {
    private static final long serialVersionUID = -1809553630528263895L;
    /**
     * 交易起始日期
     */
    private Date tradeStartDate;
    /**
     * 交易结束日期
     */
    private Date tradeEndDate;

    /**
     * 交易类型
     */
    @NotNull(message = "交易类型不能为空")
    private TradeSubTypeEnum tradeSubTypeEnum;

    /**
     * 币种
     */
    private SiteEnum siteEnum;

    private String kycNaturalId;
    private Integer startPage = 0;
    private Integer pageSize = 5;
    private ProcessStatusEnum processStatusEnum;
}