package com.js.common.model.req;

import com.js.common.annotation.Phone;
import com.js.common.enums.CountryCodeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPayVatPaymentRcvListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 注册信息表主键ID
     */
    @NotBlank(message = "用户唯一标识不能为空")
    private String kycNaturalId;
    /**
     * 税务局类型[0:税局, 1:税务代理]
     */
    @NotBlank(message = "税务局类型不能为空")
    private String taxStationType;
    /**
     * 税局国家代码
     */
    @NotBlank(message = "税局国家简称不能为空")
    private CountryCodeEnum taxStationCountry;

}
