package com.js.common.model.req;

import com.js.common.annotation.Phone;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class JsPayVatPaymentInfoReq implements Serializable {
    private static final long serialVersionUID = -1L;

    @NotBlank(message = "本机IP地址不能为空")
    private String browserIP;
    /**
     * 注册信息表主键ID
     */
    @NotBlank(message = "注册信息表主键ID不能为空")
    private String kycNaturalId;

    /**
     * 缴税人姓名
     */
    private String kycNaturalName;

    /**
     * 手机号
     */
    @NotBlank(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    /**
     * 店铺ID
     */
    @NotBlank(message = "店铺ID不能为空.")
    private List<String> subAcctNoList;

    /**
     * 税局机构id
     */
    private String taxStationId;

    /**
     * 税局机构名称
     */
    private String taxStationName;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 税务局类型[0:税局, 1:税务代理]
     */
    private String taxStationType;

    /**
     * 缴税收款账号
     */

    private String bankCardNo;

    /**
     * 缴税金额
     */
    @NotNull(message = "缴税金额不能为空")
    private BigDecimal vatPayAmt;

    /**
     * 缴税金额币种
     */
    private String vatPayCur;

    /**
     * 增值税注册号
     */
    @NotBlank(message = "增值税注册号不能为空")
    private String vatRegisteNo;

    /**
     * 税局国家代码
     */
    private String taxStationCountry;

    /**
     * 银行识别码BIC
     */
    @NotBlank(message = "银行识别码BIC不能为空.")
    private String bankBic;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空.")
    private String bankName;

    /**
     * 银行账户名称
     */
    @NotBlank(message = "账户名称不能为空.")
    private String cusName;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift
     */
    @NotBlank(message = "路由类型不能为空")
    private String routeType;
    /**
     * 国际银行账号 IBAN
     */
    private String iban;

    /**
     * Sort Code路由号码
     */
    private String sortCode;


    /**
     * 创建人Id
     */
    @NotBlank(message = "创建人Id不能为空")
    private String createId;

    /**
     * 创建人名称
     */
    @NotBlank(message = "创建人名称不能为空")
    private String createName;
}
