package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPayTradeReq implements Serializable {
    private static final long serialVersionUID = -8263882593052674460L;
    /**
     * 注册信息表主键ID
     */
    @NotBlank(message = "注册信息表主键ID不能为空")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @NotBlank(message = "寻汇用户表主键ID不能为空")
    private String kycSunrateStoreId;

    /**
     * 入账账户号
     */
    private String inAcct;

    /**
     * 入账账户名称
     */
    private String inAcctName;

    /**
     * 出账账户号
     */
    private String outAcct;

    /**
     * 出账账户名称
     */
    private String outAcctName;

    /**
     * 外部交易单号
     */
    @NotBlank(message = "外部交易单号不能为空")
    private String tradeNo;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @NotBlank(message = "寻汇收款虚拟子账户ID不能为空")
    private String kycSunrateBankId;

    /**
     * 交易类型[0:账户入账,1:账户出账]
     */
    @NotNull(message = "交易类型不能为空")
    private Integer tradeType;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费]
     */
    @NotNull(message = "交易子类型不能为空")
    private Integer tradeSubType;

    /**
     * 操作币种
     */
    @NotBlank(message = "操作币种不能为空")
    private String curId;

    /**
     * 交易金额
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tradeAmt;

    /**
     * 出账金额
     */
    private BigDecimal outAmt;

    /**
     * 入账金额
     */
    private BigDecimal inAmt;

    /**
     * 账户剩余金额
     */
    private BigDecimal userAcctCurrAmt;

    /**
     * 交易后账户总借款
     */
    private BigDecimal userAcctBorrowAmt;

    /**
     * 用户可用金额
     */
    private BigDecimal userAcctAvailableAmt;

    /**
     * 交易后冻结余额
     */
    private BigDecimal userAcctFrozenAmt;

    /**
     * 交易时间
     */
    private Date tradeDts;

    /**
     * 创建人Id
     */
    @NotBlank(message = "创建人Id不能为空")
    private String createId;

    /**
     * 创建人名称
     */
    @NotBlank(message = "创建人名称不能为空")
    private String createName;
}