package com.js.common.model.req;

import com.js.common.enums.TradeSubTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateTradeMarketOrderReq implements Serializable {
    private static final long serialVersionUID = -3407546378399826447L;
    /**
     * 锁汇编号
     */
    private String lockNo;
    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 店铺编号
     */
    private String subAcctNo;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 卖出币种
     */
    private String sellCur;
    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;

    /**
     * 交割日期
     */
    private String valueDate;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 交易方式
     */
    private TradeSubTypeEnum tradeSubType;

    /**
     * 银行卡信息主键ID
     */
    private String kycBankId;

    /**
     * 银行账号
     */
    private String bankNo;
}